% ALPHA ENGINE DEFINITION
% Generated 26-Nov-2019 14:00:10

% SUGGESTED CITATION:
% 2015 Ford 2.7L EcoBoost V6 Engine Tier 2 Fuel - ALPHA Map Package. Version 2019-11. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2019.


% Constructor
engine = class_REVS_engine();
engine.name =  '2015 Ford 2.7L EcoBoost V6 Engine Tier 2 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.694; 
engine.num_cylinders =  6; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  10; 
engine.bore_mm =  83; 
engine.stroke_mm =  83; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     104.71975511965977	;     157.18435243460928	;     183.36429121452426	;     209.43951023931953	;     314.15926535897933	;     445.05895925855401	;     602.13859193804365	;     632.24552153494585	;     662.35245113184806		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     230.06000000000000	;     350.02999999999997	;     416.41000000000003	;     460.97811999999999	;     508.43174999999997	;     488.09447999999998	;     402.67794599999996	;     345.15252514285709	;    0.00000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	    0.00000000000000000	;     131.01649670336204	;     235.73648874554465	;     366.75421695243710	;     471.44509393129323	;     525.00091508751802	;     662.35245113184806		]; 
engine.naturally_aspirated_torque_Nm = [	     177.01373129711121	;     164.83824751007714	;     163.11243753133772	;     178.97027918601964	;     210.22227530483872	;     214.11090264907719	;     196.46906097392107		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     131.00441365469436	;     288.08404633418399	;     314.26398511409894	;     418.98374023375868	;     471.34361779358858	;     662.35245113184806		]; 
engine.closed_throttle_torque_Nm = [	    -11.473129230769228	;    -12.369999999999999	;    -22.750000000000000	;    -28.680000000000000	;    -25.370000000000001	;    -14.699999999999999	;    -16.007667692307692		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     31.459559767197788	;     62.919119534395577	;     104.84192816729936	;     131.01649670336204	;     157.19416991165178	;     183.37045120011953	;     209.55470196995117	;     235.73648874554465	;     261.90718754706666	;     288.08404633418394	;     314.36576660448463	;     366.75421695243710	;     419.10518084046606	;     471.44509393129323	;     525.00091508751802	;     575.62521136093756	;     618.98883124639281	;     662.35245113184806		]; 
engine.fuel_map_torque_Nm = [	    -30.114000000000001	;    -17.578823529411764	;   -0.58999999999999997	;     25.218833333333336	;     55.537777777777777	;     80.155833333333334	;     104.37500000000000	;     117.65199999999999	;     144.49029411764707	;     178.61375000000001	;     199.14357142857142	;     225.90000000000001	;     250.61500000000001	;     280.40499999999997	;     315.27429687500000	;     344.01165539148354	;     376.65134651107405	;     405.25664460393409	;     438.68760604056433	;     469.19035353535355	;     491.92833333333334	;     512.89083541666662	;     533.85333749999995		]; 
engine.fuel_map_gps = [
   0.19847310126637593	   0.27397056250365287	   0.34427081257484354	   0.41521067769679654	   0.44201580890487235	   0.46440174038922433	   0.48643942247119432	   0.50782441296319980	   0.53029985882032904	   0.55482434365761835	   0.57806762636280995	   0.60734742515549955	   0.74203175711064528	   0.89146842566484541	    1.0472079069665885	   0.95592499541071929	   0.86514833430661076	   0.79083275341019910	   0.71772770376242623	;
   0.16821378208565327	   0.24104880719615021	   0.31276243559793809	   0.39410119109923519	   0.41947584163228369	   0.44359697797520686	   0.46844902755896128	   0.49138548030586110	   0.51822933545020777	   0.55648791858826929	   0.60166023643618916	   0.65260248629800521	   0.79723585141827791	   0.96362991952675436	    1.1407499854757785	    1.2258728696240666	    1.2283885100884271	    1.2121849480226272	    1.1918823656337030	;
   0.12888769239924627	   0.19712745625809092	   0.26899017438473055	   0.36018139721202780	   0.39017085234843263	   0.41836660692797584	   0.44425160912248796	   0.47229305288699192	   0.50996891946612111	   0.57242949727967973	   0.65166425786389448	   0.74862506796514316	   0.91631736936546193	    1.1075826017598349	    1.3467135082998440	    1.6010006195381170	    1.7212696636328471	    1.7831944530981294	    1.8343916886562939	;
  0.083379297782586945	   0.14350461308769555	   0.20423906105979997	   0.31543992286606726	   0.37484076519817011	   0.44191983512343735	   0.51506482307928281	   0.61429698952896317	   0.72885525502383297	   0.84445888201018671	   0.97356970181968472	    1.1156358677489637	    1.3475215750173923	    1.5811476671128712	    1.9085784665903713	    2.2322471207057970	    2.4801475500339754	    2.6531954700355742	    2.8112445409978917	;
  0.070279222049424883	   0.18239943227106761	   0.29718359276964762	   0.47447581523514282	   0.60486189915120769	   0.72465387111590196	   0.86460474548901745	    1.0085486664245342	    1.1560415870966327	    1.3010631419810943	    1.4555185805637669	    1.6305606481463697	    1.9620673271300015	    2.3207711411461744	    2.7156800917415036	    3.0844118082005645	    3.4255147786953115	    3.7047580428253601	    3.9766002075335818	;
  0.099243435151275414	   0.26836828062777462	   0.43895402891095947	   0.63111038129971220	   0.80133149612056231	   0.96612782024984867	    1.1258621188770894	    1.2792933466592096	    1.4550805674860952	    1.6431567676692485	    1.8442081326666426	    2.0645651056312286	    2.4722876682443924	    2.9190502135942009	    3.3773527477207952	    3.8242723116228436	    4.2464187930322757	    4.6076246834950441	    4.9678488869424875	;
   0.15709313101963518	   0.35554794289213382	   0.55266211216427186	   0.81504437466442348	    1.0047619254551436	    1.1944732957588831	    1.3872900422051229	    1.5803130928065805	    1.7937182961863374	    2.0248610020499482	    2.2595034871969486	    2.5004556709889956	    2.9822027834064246	    3.4918653703122540	    4.0349116912256635	    4.5774640428527542	    5.0962724845275007	    5.5478285356469001	    6.0028012203701300	;
   0.19668397683748201	   0.40945731319309098	   0.62232940240859147	   0.91540607017099451	    1.1114775452067756	    1.3191023291543320	    1.5378325111458140	    1.7525043350871772	    1.9848202431829876	    2.2347450141609877	    2.4869384314965139	    2.7423275526009618	    3.2653767460800194	    3.8091074250055579	    4.3973148383973397	    4.9968643332051981	    5.5761897907262314	    6.0840903882811288	    6.5975663937351676	;
   0.29424098490598077	   0.53675208976012379	   0.78095631376072838	    1.1137806361922638	    1.3295351687705885	    1.5797957372446974	    1.8358253256096426	    2.0945243971104395	    2.3660594936213695	    2.6492235788110197	    2.9361632610705812	    3.2308531680549883	    3.8440351050226513	    4.4746148233987384	    5.1387953375616968	    5.8593311760093894	    6.5805733649280151	    7.2216516520586644	    7.8725432815859238	;
   0.46501294039468721	   0.74748617152833519	    1.0333659919972680	    1.4322756065373170	    1.7041008473442718	    1.9550423580357581	    2.2259773382920991	    2.5136767903071400	    2.8186187518471875	    3.1382282208276289	    3.4726686976863528	    3.8272641483440726	    4.5684606068649583	    5.3096462252050083	    6.0862216900319117	    7.0051347083397131	    7.9796709833176038	    8.8589399560475286	    9.7531992764684201	;
   0.58125954738386831	   0.89234866166219318	    1.2063308590316524	    1.6378766147676189	    1.9139770955021775	    2.1797434075965723	    2.4587998120661010	    2.7646120553730817	    3.0980013979086216	    3.4470690114380598	    3.8125715721409779	    4.1929724423142405	    4.9901593395316306	    5.7620378893080568	    6.6354510878459587	    7.7268345360373116	    8.9002815608541006	    9.9568350487012172	    11.028601788620307	;
   0.73329659750303933	    1.0888984682257663	    1.4416145697516869	    1.9072132271285334	    2.2118230656732454	    2.4627648973925940	    2.7514728141138933	    3.0928823174976494	    3.4715527156846142	    3.8676759345834446	    4.2704453858971059	    4.6750571128443967	    5.4943900063569577	    6.3370016317299260	    7.3391330570247488	    8.7144808184134526	    10.189586882674604	    11.505155842248470	    12.833157399665449	;
   0.84743731677239109	    1.2603687286460104	    1.6686789152917954	    2.1894930125937777	    2.4903998412808246	    2.7667191368601882	    3.0765695087776761	    3.4355548201187314	    3.8390356611026886	    4.2697017952330238	    4.7104439429027485	    5.1323889546529617	    5.9815602754163519	    6.9206851036036916	    8.0381387810357570	    9.7138073987407552	    11.491199281657032	    13.063044601778181	    14.645626905588655	;
   0.92693260341309958	    1.4175312327448595	    1.9064063124050901	    2.5360962012637609	    2.8800292241283447	    3.1611690026166865	    3.4668192172993804	    3.8450089167161106	    4.2750093879587823	    4.7269274251108264	    5.1967477166139897	    5.6701039725710318	    6.6266412161765880	    7.7615525080298742	    9.1302302857887980	    11.060569407792800	    13.205292213189958	    15.091838677543086	    17.001203605247628	;
   0.91458319987062475	    1.4760340395869931	    2.0333866509745016	    2.7519064083069353	    3.1696907022069976	    3.5647027759161132	    3.9731782122109478	    4.4050528527156265	    4.8468798170614633	    5.3358499389377281	    5.8652924849413477	    6.3999153985296688	    7.5226752756050645	    8.8733051908987797	    10.478775615095950	    12.754772035739419	    15.376915099591587	    17.629236407716302	    19.966101423028793	;
   0.82346993553049375	    1.4438703637277868	    2.0629857279037123	    2.8853977154654387	    3.4029108000816017	    3.9292991136513749	    4.4744022796912244	    5.0242409397557930	    5.5210347943884042	    6.0605506217183267	    6.5572668686320936	    7.1347714984787061	    8.4325061668525745	    9.9333627866745928	    11.734544752296022	    14.229420372899352	    17.022907228334038	    19.776798276416745	    22.461537425933546	;
   0.66239082468320076	    1.3712919603209783	    2.0844805506511386	    3.0581041818527122	    3.6928744876446480	    4.3463169184654555	    5.0155203057800737	    5.6950943213516076	    6.3314265003675496	    6.9385974539382920	    7.5621139269876769	    8.2349795184566368	    9.5717921216601045	    11.065076275438992	    13.201405520363604	    16.285636859702954	    19.823889106970416	    22.493156270777185	    25.107188654510129	;
   0.50657306771336463	    1.3178668718525817	    2.1327829388002284	    3.2389383156598881	    3.9548063487654188	    4.6903469239546389	    5.4446261497163952	    6.2041876637297984	    6.9613225131692280	    7.6338640565473259	    8.4204840084343306	    9.2634921742258669	    10.469787688301459	    11.830823428218464	    14.562798377150939	    18.734345995862000	    22.002454956166211	    24.574407797647137	    27.136915343302793	;
   0.31677959476559658	    1.2841407565470790	    2.2502335536815989	    3.5322260217353896	    4.3293105533988312	    5.1295074890942951	    5.9501057592293307	    6.8311147586619825	    7.8505870445290835	    8.7730591742629063	    9.4766749884268879	    9.9234593107817108	    11.259497690846414	    13.006453917658797	    16.256582994433888	    20.265500855839683	    23.679286175412937	    26.430142878674012	    29.130308184037649	;
   0.12098657105459155	    1.2714960413909444	    2.4197837893336867	    3.9416769913755521	    4.8873077135171128	    5.8334481884321736	    6.7877319351700187	    7.7654329831316149	    8.7937498153650946	    9.6856404324221135	    10.340233794358589	    10.776225782857935	    12.038191191441372	    14.081665931163865	    17.398363812254050	    21.206606762200984	    24.736059409096807	    27.670283620091645	    30.564507934392541	;
   0.00000000000000000	    1.2684169336067592	    2.5751676477338670	    4.3128756200230809	    5.3967769879739036	    6.4816805863959068	    7.5687130151804984	    8.6557814121513470	    9.7290934990704390	    10.759105950681484	    11.728674138740377	    12.603932715302781	    12.937783853906813	    15.187114869642048	    18.298434614993340	    21.896053917515637	    25.425316871763052	    28.454318459191619	    31.474717832241453	;
   0.00000000000000000	    1.2683422616700575	    2.7312883573324860	    4.6822793631013440	    5.9005005744362524	    7.1169717028989350	    8.3264977678196352	    9.5208892598125203	    10.689253816323104	    11.821109241864253	    12.888400415077205	    13.822912189172275	    14.582670291570334	    16.454309332085010	    19.183412441879355	    22.545410214153758	    26.038621570473214	    29.131492070030006	    32.251244772482082	;
   0.00000000000000000	    1.2694876278929226	    2.8927309616881272	    5.0617855405741636	    6.4156377004370908	    7.7644979918687751	    9.0991597244438065	    10.406762125665111	    11.668141844633013	    12.856937862725909	    13.941322331835998	    14.900958000819129	    16.301464623639987	    17.830327263134233	    20.102929978281249	    23.203338616830976	    26.646978213102130	    29.793628582518352	    33.003979175198175	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 25278');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    10.000000000000000		]; 
engine.idle_speed_radps.table = [	     73.303828583761842	;     73.303828583761842		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
engine.DFCO_min_duration_secs =  2; 
engine.DFCO_refuel_multiplier_time_secs = [	    0.00000000000000000	   0.10000000000000001	    4.0000000000000000		]; 
